#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
uniform sampler2D colorTex;
#else
in vec2 vTexCoord;
out vec4 fragColor;
uniform sampler2DRect colorTex;
#endif

void main()
{
#ifdef GL_ES
	vec4 color = texture2D(colorTex, vTexCoord.st);
    gl_FragColor = vec4(color.rgb * color.a, color.a);
#else
	vec4 color = texture(colorTex, vTexCoord.st);
    fragColor = vec4(color.rgb * color.a, color.a);
#endif
}
